/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block;

import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.registries.RegistryObject;
import xfacthd.framedblocks.api.data.CamoContainer;
import xfacthd.framedblocks.api.util.FramedProperties;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.FramedBlock;
import xfacthd.framedblocks.common.block.rail.FramedRailSlopeBlock;
import xfacthd.framedblocks.common.blockentity.FramedDoubleBlockEntity;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.item.FramedBlueprintItem;

public abstract class AbstractFramedDoubleBlock
extends FramedBlock {
    private static final Map<BlockState, Tuple<BlockState, BlockState>> STATE_PAIRS = new IdentityHashMap<BlockState, Tuple<BlockState, BlockState>>();

    public AbstractFramedDoubleBlock(BlockType blockType) {
        super(blockType);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FramedProperties.SOLID, FramedProperties.GLOWING});
    }

    @Override
    public SoundType getSoundType(BlockState state, LevelReader level, BlockPos pos, Entity entity) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof FramedDoubleBlockEntity) {
            FramedDoubleBlockEntity be = (FramedDoubleBlockEntity)blockEntity;
            return be.getSoundType();
        }
        return this.m_49962_(state);
    }

    protected void m_142387_(Level level, Player player, BlockPos pos, BlockState state) {
        BlockEntity blockEntity;
        if (level.m_5776_() && (blockEntity = level.m_7702_(pos)) instanceof FramedDoubleBlockEntity) {
            FramedDoubleBlockEntity be = (FramedDoubleBlockEntity)blockEntity;
            BlockState defaultState = be.m_58900_();
            BlockState camoOne = be.getCamo().getState();
            BlockState camoTwo = be.getCamoTwo().getState();
            level.m_5898_(player, 2001, pos, AbstractFramedDoubleBlock.m_49956_((BlockState)(camoOne.m_60795_() ? defaultState : camoOne)));
            if (camoOne != camoTwo) {
                level.m_5898_(player, 2001, pos, AbstractFramedDoubleBlock.m_49956_((BlockState)(camoTwo.m_60795_() ? defaultState : camoTwo)));
            }
        }
    }

    @Override
    public Optional<MutableComponent> printCamoBlock(CompoundTag beTag) {
        BlockState camoState = CamoContainer.load(beTag.m_128469_("camo")).getState();
        BlockState camoStateTwo = CamoContainer.load(beTag.m_128469_("camo_two")).getState();
        MutableComponent component = camoState.m_60795_() ? FramedBlueprintItem.BLOCK_NONE : camoState.m_60734_().m_49954_().m_130940_(ChatFormatting.WHITE);
        component = component.m_6881_().m_7220_((Component)Component.m_237113_((String)" | ").m_130940_(ChatFormatting.GOLD));
        component.m_7220_((Component)(camoStateTwo.m_60795_() ? FramedBlueprintItem.BLOCK_NONE : camoStateTwo.m_60734_().m_49954_().m_130940_(ChatFormatting.WHITE)));
        return Optional.of(component);
    }

    @Override
    public abstract BlockEntity m_142194_(BlockPos var1, BlockState var2);

    protected abstract Tuple<BlockState, BlockState> getBlockPair(BlockState var1);

    public static void cacheStatePairs() {
        STATE_PAIRS.clear();
        FBContent.getRegisteredBlocks().stream().map(RegistryObject::get).filter(AbstractFramedDoubleBlock.class::isInstance).map(AbstractFramedDoubleBlock.class::cast).forEach(block -> block.f_49792_.m_61056_().forEach(state -> STATE_PAIRS.put((BlockState)state, block.getBlockPair((BlockState)state))));
        FramedRailSlopeBlock.cacheStatePairs(STATE_PAIRS);
    }

    public static Tuple<BlockState, BlockState> getStatePair(BlockState state) {
        Tuple<BlockState, BlockState> pair = STATE_PAIRS.get(state);
        if (pair == null) {
            throw new IllegalArgumentException("BlockState pair requested for invalid block: " + state.m_60734_());
        }
        return pair;
    }
}

